function CE = calc_grid_cell_edges(ggrid)

% Returns a I+1xJ+2x2 array, where CC(i,j,1:2) are the X,Y coordinate of cell edges

clear CE delV

CC = ggrid.CC;
[I, J, K] = size(CC);

CE = NaN(I+1, J+1, 2);

% vector from a cell center to its lower left corner
dv = -ggrid.dl/2*ggrid.vl - ggrid.dw/2*ggrid.vw;
delV(:,:,1) = repmat(dv(1),I,J); delV(:,:,2) = repmat(dv(2),I,J);

CE(1:I, 1:J, 1:2) = CC + delV;

% add right
CE(I+1,1:J,1) = CC(I,1:J,1) + -dv(1);
CE(I+1,1:J,2) = CE(I,1:J,2);

% add top
CE(1:I,J+1,1) = CE(1:I,J,1);
CE(1:I,J+1,2) = CC(1:I,J,2) + -dv(2);

% add top right corner
CE(I+1,J+1,1) = CE(I+1,J,1);
CE(I+1,J+1,2) = CE(I,J+1,2);

end



