function VF = calc_approx_view_factors_grid(cell, ggrid)

% returns view factors from cell to grid as an array of size grid
% uses approximation rather than integration


% vector to cell center
cellpos = [cell.x cell.y cell.z];

n2 = cell.normal;
if n2(3)>0
    n2 = -n2;
end
n1 = [ 0 0 1];

A1 = ggrid.cell_area;
A2 = cell.area;

% array of grid cell centers
CC = ggrid.CC;

% approximate integrand
% terms in the integrand
% vector from grid element to cell
[I, J, ~] = size(CC);

% vector s points from grid on the ground to the receiving cell center
T = NaN(I,J,3); T(:,:,1) = repmat(cell.x,I,J); T(:,:,2)=repmat(cell.y,I,J);
s(:,:,1:2) = T(:,:,1:2) - CC;
s(:,:,3) = repmat(cell.z,I,J);

% 1/pi = 0.318309886183791

norms2 = dot(s,s,3);  % squared distance between cell center and differential element in quad
s3 = repmat(cell.z,I,J);
tP = -1.0 * squeeze(n2(1)*s(:,:,1) + n2(2)*s(:,:,2) + n2(3)*s(:,:,3)); % x -1 because s points from ground to cell
cosprod = tP.*s3;

tmpVF = 0.318309886183791*cosprod./(norms2.*norms2)*A2; %*A1/A1

% set VF to zero for grid cells which are behind the viewing cell
% make an I,J array of copies of n2
N2 = NaN(I,J,3);
N2(:,:,1) = n2(1);
N2(:,:,2) = n2(2);
N2(:,:,3) = n2(3);
u = dot(N2, -s, 3)<0;
tmpVF(u) = 0;

VF = tmpVF;
