function CC = calc_grid_cell_centers(ggrid)

% returns array of N x M x 2, where the entry (i, j, :) is the coordinates
% of the center of grid cell i,j

% unit vectors defining the grid
vw = ggrid.vw;
vl = ggrid.vl;

% construct (x,y) for grid centers
I = length(ggrid.centers_x);
J = length(ggrid.centers_y);

% construct coordinates for cell centers for a one-cell wide strip of cells along y
% dimension of grid, centered on cell00
tmp = repmat(ggrid.cell00, J, 1) + repmat(ggrid.centers_y,2,1)'.*repmat(vl,J,1);

% construct array of 2d vectors from center strip to each column of cells
tmp1 = repmat(tmp(:,1), 1, I);
tmp2 = repmat(tmp(:,2), 1, I);
tmp3(:, :, 1) = tmp1';
tmp3(:, :, 2) = tmp2';
dd(:,:,1) = repmat(ggrid.centers_x',1,J).*repmat(vw(1),I,J);
dd(:,:,2) = repmat(ggrid.centers_x',1,J).*repmat(vw(2),I,J);

CC = tmp3 + dd;