function draw_cell(ax, cell, cellcolor, addvector)

% draws the cell in specified axes

axes(ax);
hold all

% assume cell is square, find length along an edge
ll = sqrt(cell.area);

% define x, y and z coordinates of each corner, clockwise from lower left

P1 = [cell.x cell.y cell.z] - ll/2*cell.vw - ll/2*cell.vl;
P2 = P1 + ll*cell.vl;
P3 = P2 + ll*cell.vw;
P4 = P3 - ll*cell.vl;

P = [P1; P2; P3; P4];
X = P(:,1);
Y = P(:,2);
Z = P(:,3);

patch(X, Y, Z, cellcolor)

if addvector
    % plot normal extended to the surface
    lz = cell.z/abs(cell.normal(3));

    % add scale=0 to arguments to turn off auto-scaling of vector in plot
    quiver3(cell.x, cell.y, cell.z, lz*cell.normal(1), lz*cell.normal(2), lz*cell.normal(3), 0)
end

end
