function draw_grid(ax, ggrid, varargin)

% draws the grid in the specified axes
% varargin: u, size_lim
% optional input u is an array the same size as ggrid containing boolean 
% values where True indicates a shadow
% optional input size_lim is absolute value of axis limit in axis units 

% default input values

if isempty(varargin)
    u = false(length(ggrid.centers_x), length(ggrid.centers_y));
    size_lim = [];
elseif length(varargin)==1
    if isvector(varargin{1})
        size_lim = varargin{1};
        u = false(length(ggrid.centers_x), length(ggrid.centers_y));
    else
        size_lim = [];
        u = varargin{1};
    end
elseif length(varargin)==2
    u = varargin{1};
    size_lim = varargin{2};
else
    error('draw_grid: too many inputs')
end

axes(ax);

% calculate grid edges
CE = calc_grid_cell_edges(ggrid);
X = CE(:,:,1);
Y = CE(:,:,2);

if ~isempty(size_lim)
    % limit on grid extent specified
    minX = find(X(:,1)>size_lim(1),1,'first');
    maxX = find(X(:,1)<size_lim(2),1,'last');
    minY = find(Y(1,:)>size_lim(3),1,'first');
    maxY = find(Y(1,:)<size_lim(4),1,'last');
else
    minX = 1;
    maxX = length(X(:,1));
    minY = 1;
    maxY = length(Y(1,:));
end

% extend u because pcolor doesn't draw right and top row
colr = zeros(size(u, 1) + 1, size(u, 2) + 1);
colr(1:end-1, 1:end-1) = u;

f = gcf;

if not(any(any(u)))
    % all entries are zero
    colormap(f, [1 1 1])
else
    colormap(f, [1 1 1; 0.4, 0.4, 0.4]);  % fill with white for false, grey for true
end

pcolor(X(minX:maxX, minY:maxY), Y(minX:maxX, minY:maxY), colr(minX:maxX, minY:maxY));


