function draw_object(ax, obj, addvector)

% draws the object in specified axes

axes(ax);
hold all

P = [obj.LL; obj.UL; obj.UR; obj.LR];
X = P(:,1);
Y = P(:,2);
Z = P(:,3);

patch(X, Y, Z, obj.Color)

if addvector
    % plot normal
    center = [mean(X) mean(Y) mean(Z)];
    dx = (norm(obj.LR - obj.LL) + norm(obj.UR - obj.LR))/2;

    % add scale=0 to arguments to turn off auto-scaling of vector in plot
    quiver3(center(1), center(2), center(3), dx*obj.normal(1), dx*obj.normal(2), dx*obj.normal(3), 0)
end

end
