function skyVF = calc_sky_VF_vec(ggrid, obj)

% calculates fraction of sky blocked by obj at each cell
% in ggrid

CC = ggrid.CC;

[I, J, ~] = size(CC);
viewpoint = reshape(CC, [], 2);  % ggrid centers are stored as (x,y) only
viewpoint(:,3) = 0;

skyVF = NaN(I,J);
tmp = calc_solid_angle_vec(viewpoint, obj);

% skyVF(i,j) = 1 - area/(2*pi());
skyVF = reshape(tmp, I, J)./(2*pi());

