function draw_grid_VFs(ax, ggrid, VF, varargin)

% plots the grid cell centers in the specified axes
% varargin: 
% * [minX maxX minY maxY] in grid axis coordinates
% * drawedge - boolean, if true then draw cell edges (default is false)

if length(varargin)==2
    size_lim = varargin{1};
    drawedges = varargin{2};
elseif length(varargin)==1
    size_lim = varargin{1};
    drawedges = false;
else
    size_lim = [];
    drawedges = false;
end
    
axes(ax);

CE = calc_grid_cell_edges(ggrid);
X = CE(:,:,1);
Y = CE(:,:,2);

if ~isempty(size_lim)
    % limit on grid extent specified
    minX = find(X(:,1)>size_lim(1),1,'first');
    maxX = find(X(:,1)<size_lim(2),1,'last');
    minY = find(Y(1,:)>size_lim(3),1,'first');
    maxY = find(Y(1,:)<size_lim(4),1,'last');
else
    minX = 1;
    maxX = length(X(:,1));
    minY = 1;
    maxY = length(Y(1,:));
end

% extend VF by one row to the right and top, due to use poor matlab code
[I, J] = size(VF);
cVF = NaN(I+1, J+1);
cVF(1:I, 1:J) = VF;
cVF(I+1, 1:J) = 0;
cVF(1:I, J+1) = 0;
cVF(I+1, J+1) = 0;

if ~isempty(size_lim)
    minX = find(X(:,1)>size_lim(1),1,'first');
    maxX = find(X(:,1)<size_lim(2),1,'last');
    minY = find(Y(1,:)>size_lim(3),1,'first');
    maxY = find(Y(1,:)<size_lim(4),1,'last');
else
    minX = 1;
    maxX = length(X(:,1));
    minY = 1;
    maxY = length(Y(1,:));
end

h = pcolor(X(minX:maxX,minY:maxY), Y(minX:maxX,minY:maxY), cVF(minX:maxX,minY:maxY));
if ~drawedges
    set(h, 'EdgeColor', 'none')
end

end
