
%% Define cells for selected modules.

% Calculate ground-facing unit normal for a cell. Order is reversed so that
% the normal points to the earth surface.
normal = cross(vl, vw);

cells = [];
ptr = 0;

for k=1:size(which_modules, 1)
    row = which_modules(k, 1);
    pos = which_modules(k, 2);
    mod_LL = objects((row - 1)*num_modules_per_row + pos).LL;

    cell_center_LL = mod_LL + cell_offset_from_left_edge*vw + ...
                              cell_offset_from_bottom*vl + ...
                              cell_width/2*vw + ...
                              cell_length/2*vl;

    if strcmp(module_orientation, 'portrait')

        for i=1:num_cells_width
            for j=1:num_cells_length
                ptr = ptr + 1;
                cells(ptr).name = ['Row' num2str(row) ' Pos' num2str(pos) ', Cell (' num2str(j) ',' num2str(i) ')'];
                center = cell_center_LL + (i-1)*cell_width*vw + (j-1)*cell_length*vl;
                cells(ptr).x = center(1);
                cells(ptr).y = center(2);
                cells(ptr).z = center(3);
                cells(ptr).normal = normal;
                cells(ptr).width = cell_width;
                cells(ptr).length = cell_length;
                cells(ptr).area = cell_area;
                cells(ptr).vw = vw;
                cells(ptr).vl = vl;
            end
        end
    
    elseif strcmp(module_orientation, 'landscape')

        for i=1:num_cells_length
            for j=1:num_cells_width
                ptr = ptr + 1;
                cells(ptr).name = ['Row' num2str(row) ' Pos' num2str(pos) ', Cell (' num2str(j) ',' num2str(i) ')'];
                center = cell_center_LL + (i-1)*cell_length*vw + (j-1)*cell_width*vl;
                cells(ptr).x = center(1);
                cells(ptr).y = center(2);
                cells(ptr).z = center(3);
                cells(ptr).normal = normal;
                cells(ptr).width = cell_width;
                cells(ptr).length = cell_length;
                cells(ptr).area = cell_area;
                cells(ptr).vw = vw;
                cells(ptr).vl = vl;
            end
        end
        
    else
        msgbox(['module_orientation = ' module_orientation ', value not recognized'])
        exit
    end
    
end


if make_figure
    % draw picture of cells on top of objects
    figure
    ax=gca;
    hold all
    for k=1:length(objects)
        draw_object(ax, objects(k), false)
    end

    for k=1:length(cells)
        draw_cell(ax, cells(k), [0.5 0 0], false)
    end
    draw_northarrow(ax);
    view(3)
    axis equal
    grid on
end

clearvars k center
