function [u] = select_grid_points_InPolygon(ggrid, objects, SunVec)

% Returns a boolean array indicating which grid points are inside the union
% of quadrilateral shadows cast by objects with sun at SunVec. Uses a MEX
% file built from C code by Guillaume Jacquenot.

% input ggrid is a grid structure.
% input objects is a structure array of objects with corners given in 3d
% coordinates.
% input SunVec is a single vector from the earth to the sun.
% output u is a boolean array of the same size as the grid center array in
% ggrid.  u(i,j) = 1 indicates that the grid point at i,j is inside the
% union of quadrilateral shadows.

% The algorithm first forms arrays of object corners from lower left (LL)
% in a clockwise direction. Next the corners are projected to quadrilateral
% shadows on the ground along the reverse of the sun vector. Finally, for
% each quadrilateral, grid points inside the shadow are identified by a dot
% product operation that determines which grid points are left or right of
% each line passing through two quadrilateral corners.

CC = ggrid.CC; % for convenience
I = length(ggrid.centers_x); % number of grid cells in the width dimension
J = length(ggrid.centers_y); % number of grid cells in the length dimension

u = false(I,J);
% find left/right filters for each side of the quadrilateral

% form array of object corners in clockwise orientation. insert row of 
% NaNs between objects
X = NaN(4, 3);
for j = 1:length(objects)
    X = [objects(j).LL; objects(j).UL; objects(j).UR; objects(j).LR];
    Y = project_to_plane(X, SunVec);

    Y = Y(:,1:2); % discard z coordinate.

    tmp2 = InPolygon(reshape(CC(:,:,1),[],1), reshape(CC(:,:,2),[],1), Y(:,1), Y(:,2));
    u = u | reshape(tmp2, I, J);
end



